------------------------------------------------------------
-- Save New Version -- Revision: 2.4
--
-- Saves the current composition with a version number - incrementing the version 
-- each time the script is called.
--
-- this is a composition type script, and must be run from the 
-- scripts/composition directory of fusion
--
-- written by Isaac Guenard (izyk@eyeonline.com)
-- edited by Sean Konrad (sean@eyeonline.com)
-- edited by Daniel Koch (daniel@eyeonline.com)
-- edited by Axel Mertes
-- written : Nov 11th, 2002
-- updated : Sept 27, 2005
-- changes : updated for 5
-- updated : April 5, 2006 (actually works now)
-- updated : April 5, 2006 (forces first save to be enumerated with default 3 digits padding,
--           fixed first save dialog path issues)
-- updated : April 6, 2006 (reports failures, won't clobber existing comps)
------------------------------------------------------------

--------------------------------------------------------------------------
-- MAIN BODY
--

fa = composition:GetAttrs()
if fa.COMPS_FileName == "" then

    -- add the default composition name provided by Fusion
	composition_dir = composition:MapPath("comps:") .. fa.COMPS_Name..".comp"
	
	ret = composition:AskUser("Unsaved Comp", {
        {"Filename", "FileBrowse", Save=true, Default=composition_dir} 
        })
	
	if ret == nil then
		print("Save Cancelled!")
		return
	end
	
    pf = bmd.parseFilename(MapPath(ret.Filename))
	if pf.Number == nil then
		pf.Number =  1
	end
else
	pf = bmd.parseFilename(MapPath(fa.COMPS_FileName))
	if pf.Number == nil then
		pf.Number =  1
	else
		pf.Number = pf.Number + 1
	end
end	
	
-- default to 3 digits padding if no padding is given by the user
if pf.Padding then
else
	print("\nThe basic filename does not contain version numbers, set to default '001'")
	pf.Padding =  3
end

composition_new = pf.Path .. pf.CleanName..string.format("%0"..pf.Padding.."d", pf.Number)..".comp"

if fileexists(composition_new) then
	ret = composition:AskUser("File Exists!", {
		{"Description", "Text", 
		Default = composition_new.."\n\n"..
		"Do you want to overwrite the existing file?", 
		ReadOnly = true, Wrap=true} 
		} )
	if ret == nil then
		return
	end
end

-- is the filename provided even valid?
-- we find out by trying to open the file for writing.
-- if we can't we display a message with the windows error
-- (use a temporary name to avoid stomping on any existing comps)

composition_tmp = pf.Path .. pf.CleanName..string.format("%0"..pf.Padding.."d", pf.Number)..".tmp"
file, errorMsg = io.open(composition_tmp, "w")
if file == nil then
	composition:AskUser("File Save Error!", {
		{"Description", "Text", 
		Default = "Invalid Filename : The Windows error was :\n"..errorMsg, 
		ReadOnly = true, Wrap=true} 
		} )
	return
end
file:close()
  
if composition:Save( composition_new ) == true then
    print("\nThis composition has been saved as:\n"..composition_new.."\n")
else
    print("\nWarning: could not save at :\n"..composition_new.."\n")
end
--------------------------------------------------------------------------
-- SCRIPT ENDS

